package cn.k7g.alloy.annotation;

import cn.k7g.alloy.mold.var.AbsVar;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 标记为mold模板参数
 * @author victor-wu
 * @date 2024年4月3日
 */
@Target({ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
public @interface MoldParam {
    /**
     * 数据提供器
     * @return
     */
    Class<? extends AbsVar> var();
    /**
     * 变量名, 留空表示使用参数名作为此名称
     * @return
     */
    String name() default "";
}
