package cn.k7g.alloy.annotation;

import cn.k7g.alloy.expose.AlloyContentHandler;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * 根据信息归属者加密内容输出，防止数据篡改
 * 暂不支持直接在方法上添加此注解做全局加密，
 *
 *  将输出的内容根据 数据归属者key/id 加密， 这个key可以用户ID  租户ID  商户ID等等
 *  具体实现参考
 *  @see cn.k7g.alloy.expose.AlloyContentHandler
 * @author victor-wu
 * @date 2024年4月3日
 *
 *
<code>
        这是演示读取数据
        @RequestMapping("hello3/{id}")
        public String hello3(@AlloyContent @PathVariable Integer id, @AlloyContent @RequestParam("aa") Integer aa) throws JsonProcessingException {
            return id.toString();
        }

        class Out {
            @AlloyContent
            private Long id;
        }


        原数据为：1
        加密数据为：uqihweiqu1e1u2heuihi=

</code>
 *
 */
@Target({ElementType.FIELD, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
public @interface AlloyContent {

    /**
     * 这返回的是Spring组件的名称， 指向加密解密的类型不同实现的
     * @see AlloyContentHandler
     */
    String value() default AlloyContentHandler.DEFAULT_BEAN_NAME;
}
