/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.utils;

import cn.k7g.alloy.exception.PasswordInvalidException;
import org.apache.commons.lang3.StringUtils;

public class PasswordUtil {
    public static int PASSWORD_MIN_LENGTH = 8;
    public static int PASSWORD_STRONG_LEVEL = 3;

    public static void assertValidPassword(String newPassword) {
        if (StringUtils.isBlank((CharSequence)newPassword)) {
            throw new PasswordInvalidException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (newPassword.indexOf(" ") != -1) {
            throw new PasswordInvalidException("\u5bc6\u7801\u4e0d\u80fd\u5305\u542b\u7a7a\u683c");
        }
        String msg = "\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u6570\u5b57\uff0c\u5927\u5c0f\u5199\u5b57\u6bcd\uff0c\u7b26\u53f7\u4efb\u610f\u4e09\u79cd\u4e14\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + PASSWORD_MIN_LENGTH + "\u4f4d";
        if (StringUtils.length((CharSequence)newPassword) < PASSWORD_MIN_LENGTH) {
            throw new PasswordInvalidException(msg);
        }
        int r = 0;
        for (int i = 0; i < newPassword.length(); ++i) {
            char c = newPassword.charAt(i);
            r = c >= 'a' && c <= 'z' ? (r |= 1) : (c >= 'A' && c <= 'Z' ? (r |= 2) : (c >= '0' && c <= '9' ? (r |= 4) : (r |= 8)));
            int count = 0;
            for (int j = 0; j <= PASSWORD_STRONG_LEVEL; ++j) {
                if ((r & 1 << j) == 0) continue;
                ++count;
            }
            if (count < 3) continue;
            return;
        }
        throw new PasswordInvalidException(msg);
    }
}

