/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.utils;

import cn.k7g.alloy.annotation.Label;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.internal.engine.path.NodeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

public class AlloyUtils {
    private static final Logger log = LoggerFactory.getLogger(AlloyUtils.class);

    public static String getErrorToString(BindingResult bindingResult) {
        StringBuilder sb = new StringBuilder();
        for (ObjectError error : bindingResult.getAllErrors()) {
            try {
                if (!error.contains(ConstraintViolationImpl.class)) continue;
                ConstraintViolationImpl source = (ConstraintViolationImpl)error.unwrap(ConstraintViolationImpl.class);
                Path propertyPath = source.getPropertyPath();
                Iterator iterator = propertyPath.iterator();
                StringBuilder labelStr = new StringBuilder();
                Object bean = source.getRootBean();
                while (iterator.hasNext()) {
                    Path.Node next = (Path.Node)iterator.next();
                    if (next.getKind() != ElementKind.PROPERTY) continue;
                    if (bean instanceof List) {
                        bean = ((List)bean).get(next.getIndex());
                        labelStr.append("\u7b2c").append(next.getIndex() + 1).append("\u884c").append(" ");
                    } else if (bean instanceof Object[]) {
                        bean = ((Object[])bean)[next.getIndex()];
                        labelStr.append("\u7b2c").append(next.getIndex() + 1).append("\u884c").append(" ");
                    }
                    Field field = FieldUtils.getField(bean.getClass(), (String)next.getName(), (boolean)true);
                    bean = field.get(bean);
                    Label label = field.getAnnotation(Label.class);
                    if (label != null && label.enhanceVerifyMessage()) {
                        labelStr.append(label.value());
                    } else {
                        labelStr.append(next.getName());
                    }
                    labelStr.append(" ");
                }
                sb.append((CharSequence)labelStr).append(error.getDefaultMessage()).append("\n");
            }
            catch (Exception ex) {
                log.error("\u589e\u5f3a\u9519\u8bef\u63d0\u793a\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)ex);
                sb.append(error.getDefaultMessage()).append("\n");
            }
        }
        return sb.toString();
    }

    public static String getFieldAlias(ConstraintViolation o) {
        Path propertyPath = o.getPropertyPath();
        String fieldName = propertyPath.toString();
        Iterator iterator = propertyPath.iterator();
        NodeImpl methodNode = null;
        NodeImpl paramNode = null;
        while (iterator.hasNext()) {
            Path.Node node = (Path.Node)iterator.next();
            if (node instanceof NodeImpl) {
                if (node.getKind() == ElementKind.METHOD) {
                    methodNode = (NodeImpl)node;
                } else if (node.getKind() == ElementKind.PARAMETER) {
                    paramNode = (NodeImpl)node;
                }
            }
            if (methodNode != null && paramNode != null) {
                fieldName = AlloyUtils.getFieldAlias(o, methodNode, paramNode);
                continue;
            }
            fieldName = node.getName();
        }
        return fieldName;
    }

    private static String getFieldAlias(ConstraintViolation o, NodeImpl methodNode, NodeImpl paramNode) {
        Annotation[] parameterAnnotation;
        List parameterTypes = methodNode.getParameterTypes();
        Class[] types = parameterTypes.toArray(new Class[0]);
        Method method = MethodUtils.getAccessibleMethod((Class)o.getRootBeanClass(), (String)methodNode.getName(), (Class[])types);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (Annotation annotation : parameterAnnotation = parameterAnnotations[paramNode.getParameterIndex()]) {
            if (!(annotation instanceof Label)) continue;
            Label label = (Label)annotation;
            if (!label.enhanceVerifyMessage()) break;
            return label.value();
        }
        return paramNode.getName();
    }
}

