/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.core.objectmapper;

import cn.k7g.alloy.annotation.TimeExtra;
import cn.k7g.alloy.core.objectmapper.Timestamp;
import cn.k7g.alloy.utils.TimeUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;

public class TimeExtraSerializer
extends JsonSerializer<Object> {
    private TimeExtra timeExtra;

    public TimeExtraSerializer(TimeExtra timeExtra) {
        this.timeExtra = timeExtra;
    }

    public void serialize(Object v, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (v == null) {
            jsonGenerator.writeNull();
            return;
        }
        jsonGenerator.writeObject(v);
        String currentName = jsonGenerator.getOutputContext().getCurrentName() + "Extra";
        Extra extra = this.convert(v);
        jsonGenerator.writeObjectField(currentName, (Object)extra);
    }

    private Extra convert(Object v) {
        Extra extra = new Extra();
        if (v instanceof LocalDateTime) {
            extra.timestamp = new Timestamp(((LocalDateTime)v).toInstant(ZoneOffset.ofHours(8)).toEpochMilli());
            this.fill(extra);
            return extra;
        }
        if (v instanceof Date) {
            extra.timestamp = new Timestamp(((Date)v).getTime());
            this.fill(extra);
            return extra;
        }
        if (v instanceof LocalDate) {
            extra.timestamp = new Timestamp(((LocalDate)v).atStartOfDay().toInstant(ZoneOffset.ofHours(8)).toEpochMilli());
            this.fill(extra);
            return extra;
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u683c\u5f0f\u7c7b\u578b\uff01");
    }

    private void fill(Extra extra) {
        if (this.timeExtra.timeDuration()) {
            extra.duration = new Timestamp(System.currentTimeMillis() - extra.timestamp.get());
            extra.durationLabel = TimeUtil.getDurationLabel(extra.duration.get());
        }
    }

    static class Extra
    implements Serializable {
        private Timestamp timestamp;
        private Timestamp duration;
        private String durationLabel;

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public Timestamp getDuration() {
            return this.duration;
        }

        public String getDurationLabel() {
            return this.durationLabel;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public void setDuration(Timestamp duration) {
            this.duration = duration;
        }

        public void setDurationLabel(String durationLabel) {
            this.durationLabel = durationLabel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Extra)) {
                return false;
            }
            Extra other = (Extra)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Timestamp this$timestamp = this.getTimestamp();
            Timestamp other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
                return false;
            }
            Timestamp this$duration = this.getDuration();
            Timestamp other$duration = other.getDuration();
            if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
                return false;
            }
            String this$durationLabel = this.getDurationLabel();
            String other$durationLabel = other.getDurationLabel();
            return !(this$durationLabel == null ? other$durationLabel != null : !this$durationLabel.equals(other$durationLabel));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Extra;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Timestamp $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            Timestamp $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            String $durationLabel = this.getDurationLabel();
            result = result * 59 + ($durationLabel == null ? 43 : $durationLabel.hashCode());
            return result;
        }

        public String toString() {
            return "TimeExtraSerializer.Extra(timestamp=" + this.getTimestamp() + ", duration=" + this.getDuration() + ", durationLabel=" + this.getDurationLabel() + ")";
        }
    }
}

