/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.core.objectmapper;

import cn.k7g.alloy.annotation.AlloyContent;
import cn.k7g.alloy.exception.AlloyContentDecodeException;
import cn.k7g.alloy.exception.AlloyMessageException;
import cn.k7g.alloy.expose.AlloyContentHandler;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class AlloyContentDeserializer
extends JsonDeserializer<Object> {
    private AlloyContent alloyContent;
    private AlloyContentHandler alloyContentHandler;
    private Class dataType;
    @Autowired
    private BeanFactory beanFactory;

    public AlloyContentDeserializer(AlloyContent alloyContent, Class dataType) {
        this.alloyContent = alloyContent;
        this.dataType = dataType;
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        AlloyContentHandler handler = this.getHandler();
        try {
            return handler.decodeObject(jsonParser.getValueAsString(), this.dataType);
        }
        catch (AlloyContentDecodeException e) {
            throw new AlloyMessageException(e);
        }
    }

    public AlloyContentHandler getHandler() {
        if (this.alloyContentHandler == null) {
            this.alloyContentHandler = AlloyContentHandler.newInstance(this.beanFactory, this.alloyContent);
        }
        return this.alloyContentHandler;
    }
}

