/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.expose;

import cn.k7g.alloy.annotation.AlloyContent;
import cn.k7g.alloy.exception.AlloyContentDecodeException;
import cn.k7g.alloy.exception.AlloyContentEncodeException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class AlloyContentHandler {
    public static final String DEFAULT_BEAN_NAME = "alloyContentHandler";
    @Autowired
    @Lazy
    private ObjectMapper objectMapper;

    public static AlloyContentHandler newInstance(BeanFactory beanFactory, AlloyContent alloyContent) {
        return (AlloyContentHandler)beanFactory.getBean(alloyContent.value());
    }

    public abstract byte[] anonymousOwnerKey();

    public abstract byte[] ownerKey();

    public abstract boolean isLogin();

    public byte[] getKey() {
        return this.getKey(false);
    }

    public byte[] getKey(boolean forceAny) {
        byte[] key;
        byte[] byArray = key = !forceAny && this.isLogin() ? this.ownerKey() : this.anonymousOwnerKey();
        if (key.length > 32) {
            throw new RuntimeException("alloy key \u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
        }
        if (key.length == 16 || key.length == 24 || key.length == 32) {
            return key;
        }
        if (key.length < 16) {
            return this.fill(key, 16);
        }
        if (key.length < 24) {
            return this.fill(key, 24);
        }
        return this.fill(key, 32);
    }

    public byte[] fill(byte[] key, int len) {
        byte[] nk = new byte[len];
        System.arraycopy(key, 0, nk, 0, key.length);
        for (int i = key.length; i < nk.length; ++i) {
            nk[i] = 48;
        }
        return nk;
    }

    public static String decode(String value, byte[] key) throws AlloyContentDecodeException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, secretKeySpec);
            byte[] decryptedBytes = cipher.doFinal(Base64.getUrlDecoder().decode(value));
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new AlloyContentDecodeException("\u65e0\u6548\u7684\u53c2\u6570\u6570\u636e", e);
        }
    }

    public static String encode(String originId, byte[] key) throws AlloyContentEncodeException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKeySpec);
            byte[] encryptedBytes = cipher.doFinal(originId.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(encryptedBytes);
        }
        catch (Exception e) {
            throw new AlloyContentEncodeException("\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public <T> T decodeObject(String content, Class<T> dataType) throws AlloyContentDecodeException {
        try {
            String originContent;
            try {
                originContent = AlloyContentHandler.decode(content, this.getKey());
            }
            catch (Exception e) {
                if (this.isLogin()) {
                    originContent = AlloyContentHandler.decode(content, this.getKey(true));
                }
                throw e;
            }
            return (T)this.objectMapper.readValue(originContent, dataType);
        }
        catch (JsonProcessingException e) {
            throw new AlloyContentDecodeException("JSON\u6570\u636e\u683c\u5f0f\u9519\u8bef", e);
        }
    }

    public String encodeObject(Object o) throws AlloyContentEncodeException {
        try {
            return AlloyContentHandler.encode(this.objectMapper.writeValueAsString(o), this.getKey());
        }
        catch (JsonProcessingException e) {
            throw new AlloyContentEncodeException("\u6570\u636e\u65e0\u6cd5\u8f6c\u6362\u4e3ajson\u683c\u5f0f", e);
        }
    }
}

