/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.core.objectmapper;

import cn.k7g.alloy.annotation.AlloyContent;
import cn.k7g.alloy.expose.AlloyContentHandler;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class AlloyContentSerializer
extends JsonSerializer<Object> {
    @Autowired
    private BeanFactory beanFactory;
    private AlloyContent alloyContent;
    private AlloyContentHandler alloyContentHandler;

    public AlloyContentSerializer(AlloyContent alloyContent) {
        this.alloyContent = alloyContent;
    }

    public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (o == null) {
            jsonGenerator.writeNull();
            return;
        }
        jsonGenerator.writeString(this.getHandler().encodeObject(o));
    }

    public AlloyContentHandler getHandler() {
        if (this.alloyContentHandler == null) {
            this.alloyContentHandler = AlloyContentHandler.newInstance(this.beanFactory, this.alloyContent);
        }
        return this.alloyContentHandler;
    }
}

