/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.autoconfiguration;

import cn.k7g.alloy.annotation.MoldContent;
import cn.k7g.alloy.annotation.MoldParam;
import cn.k7g.alloy.autoconfiguration.AlloyAutoConfigurationSelector;
import cn.k7g.alloy.autoconfiguration.EnableAlloyAutoConfiguration;
import cn.k7g.alloy.mold.BaseMold;
import cn.k7g.alloy.mold.MoldService;
import cn.k7g.alloy.mold.var.AbsVar;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.cglib.proxy.Proxy;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class AlloyBeanDefinitionRegister
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(AlloyBeanDefinitionRegister.class);

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator importBeanNameGenerator) {
        String[] enhanceExceptionMessageProperties;
        AnnotationAttributes enableAlloy = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableAlloyAutoConfiguration.class.getName(), false));
        try {
            String[] moldBasePackages = AlloyAutoConfigurationSelector.enableAlloy.getStringArray("moldBasePackages");
            if (moldBasePackages != null && moldBasePackages.length > 0) {
                this.scanMoldContent(registry, importBeanNameGenerator, moldBasePackages);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (BeanDefinitionStoreException e) {
            throw new RuntimeException(e);
        }
        Properties properties = new Properties();
        for (String enhanceExceptionMessageProperty : enhanceExceptionMessageProperties = enableAlloy.getStringArray("enhanceExceptionMessageProperties")) {
            try {
                properties.load(ResourceUtils.getURL((String)enhanceExceptionMessageProperty).openStream());
            }
            catch (Exception e) {
                log.debug("\u52a0\u8f7d\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            }
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(Properties.class, () -> properties);
        registry.registerBeanDefinition("cn.k7g.alloy.ioc.processor.EnhanceExceptionResponse.EXCEPTION_MESSAGES_PROPERTIES", (BeanDefinition)beanDefinitionBuilder.getRawBeanDefinition());
    }

    private void scanMoldContent(BeanDefinitionRegistry registry, BeanNameGenerator importBeanNameGenerator, String[] moldBasePackages) throws ClassNotFoundException {
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return true;
            }
        };
        scanner.resetFilters(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(MoldContent.class));
        for (String basePackage : moldBasePackages) {
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition beanDefinition : candidateComponents) {
                BeanDefinitionBuilder factoryBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(MoldContentFactoryBean.class);
                factoryBeanDefinitionBuilder.addPropertyValue("beanCls", Class.forName(beanDefinition.getBeanClassName()));
                factoryBeanDefinitionBuilder.addPropertyReference("moldService", "moldService");
                AbstractBeanDefinition factoryBeanDefinition = factoryBeanDefinitionBuilder.getBeanDefinition();
                registry.registerBeanDefinition(importBeanNameGenerator.generateBeanName(beanDefinition, registry), (BeanDefinition)factoryBeanDefinition);
            }
        }
    }

    public static class MoldContentFactoryBean<T>
    implements FactoryBean<T> {
        private Class<T> beanCls;
        private MoldService moldService;

        public void setBeanCls(Class<T> beanCls) {
            this.beanCls = beanCls;
        }

        public void setMoldService(MoldService moldService) {
            this.moldService = moldService;
        }

        public T getObject() throws Exception {
            System.out.println(this.beanCls.getAnnotation(MoldContent.class));
            return (T)Proxy.newProxyInstance((ClassLoader)MoldContentFactoryBean.class.getClassLoader(), (Class[])new Class[]{this.beanCls}, (target, method, argv) -> {
                String msg;
                MoldContent objectMoldContent = this.beanCls.getAnnotation(MoldContent.class);
                MoldContent methodMoldContent = method.getAnnotation(MoldContent.class);
                Predicate<MoldContent.Level> NotEqualsDefault = o -> o != MoldContent.Level.DEFAULT;
                MoldContent.Level execLevel = Optional.of(methodMoldContent.execLevel()).filter(NotEqualsDefault).orElseGet(() -> Optional.of(objectMoldContent.execLevel()).filter(NotEqualsDefault).orElse(MoldContent.Level.SAFE));
                String value = Optional.ofNullable(methodMoldContent.value()).orElse(objectMoldContent.value());
                String trigger = Optional.ofNullable(methodMoldContent.trigger()).orElse(objectMoldContent.trigger());
                BaseMold baseMold = new BaseMold().setContent(value);
                for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
                    Parameter parameter = method.getParameters()[i];
                    MoldParam param = this.findAnno(method.getParameterAnnotations()[i], MoldParam.class);
                    if (param == null) {
                        baseMold.addConstVar(parameter.getName(), (Serializable)argv[i]);
                        continue;
                    }
                    Class<? extends AbsVar> var = param.var();
                    Constructor<? extends AbsVar> constructor = var.getConstructor(String.class, parameter.getType());
                    baseMold.addVar(constructor.newInstance(param.name(), argv[i]));
                }
                switch (execLevel) {
                    case SAFE: {
                        msg = this.moldService.createContent(baseMold).toString();
                        break;
                    }
                    case MIX_UNSAFE: {
                        msg = this.moldService.createContentMixUnsafe(baseMold).toString();
                        break;
                    }
                    case UNCONTROLLED: {
                        msg = this.moldService.createContentUncontrolled(baseMold).toString();
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u672a\u77e5\u7684\u6267\u884c\u65b9\u5f0f");
                    }
                }
                Object triggerRet = null;
                if (StringUtils.hasText((String)trigger)) {
                    BaseMold triggerMold = new BaseMold().setContent(trigger).addConstVar("_result", (Serializable)((Object)msg));
                    triggerRet = this.moldService.createContentUncontrolled(triggerMold);
                }
                if (method.getReturnType() == Void.TYPE) {
                    return null;
                }
                if (triggerRet != null && triggerRet.getClass() == method.getReturnType()) {
                    return triggerRet;
                }
                if (method.getReturnType() == String.class) {
                    return msg;
                }
                return null;
            });
        }

        public <T> T findAnno(Annotation[] arr, Class<T> find) {
            for (Annotation annotation : arr) {
                if (annotation.annotationType() != find) continue;
                return (T)annotation;
            }
            return null;
        }

        public Class<?> getObjectType() {
            return this.beanCls;
        }
    }
}

