package cn.k7g.alloy.validator;

import cn.k7g.alloy.annotation.verify.NotNullElement;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Collection;

/**
 * @author victor-wu
 * @date 2024/8/19 上午9:59
 */
public class NotNullElementValidator implements ConstraintValidator<NotNullElement, Collection> {

    @Override
    public void initialize(NotNullElement constraintAnnotation) {

    }

    @Override
    public boolean isValid(Collection value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }

        if (value.isEmpty()) {
            return true;
        }

        for (Object o : value) {
            if (o == null) {
                return false;
            }
        }
        return true;
    }
}
