package cn.k7g.alloy.mold;

/**
 * 模具生产服务
 * 通常情况下不建议重写此类，如有需要对内容扩，展建议是在 BaseMold 下再实现一层 进行预处理 content
 * @date  2021/2/5 下午1:46
 * @author victor-wu
 */
public interface MoldService {
    /**
     * 仅支持数据值的调用，不支持方法调用
     * @param baseMold
     * @return
     */
    Object createContent(BaseMold baseMold);

    /**
     * 支持方法的调用, 注意如果有前端提交的内容，不建议使用此方法。可能是造成安全问题。
     * 优先考虑采用 createContent 方法
     * @param baseMold
     * @return
     */
    Object createContentMixUnsafe(BaseMold baseMold);


    /**
     * 比 createContentMixUnsafe 调用范围更大，支持调用 spring component
     * 调用spring component #{@xxxService.func()}
     *
     * @param baseMold
     * @return
     */
    Object createContentUncontrolled(BaseMold baseMold);

}
