package cn.k7g.alloy.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.lang.Nullable;


/**
 * BetweenSortScope
 * @author victor-wu
 * @date 2021/9/27 下午1:10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BetweenSortScope {
    /**
     * start 和 and 不能同时为空
     */
    @Nullable
    private SortOrder start;
    @Nullable
    private SortOrder end;

    public void assertVerify() {
        if (start == null && end == null) {
            throw new RuntimeException("start 与 end 不能同时为空");
        }
    }
}
