package cn.k7g.alloy.expose;

import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

/**
 * 默认的验证处理
 * @author victor-wu
 * @date 2024年4月3日
 */
@Slf4j
public final class DefaultRestExceptionResponseHandler implements WebExceptionResponseHandler {
    @Override
    public Object handle(String msg, Exception e) {
        log.error(msg, e);
        Map<String, Object> ret = new HashMap<>();
        ret.put("msg", msg);
        ret.put("code", 500);
        return ret;
    }
}
