package cn.k7g.alloy.annotation;

import org.springframework.core.annotation.AliasFor;
import org.springframework.stereotype.Component;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 将标注对象注册到 mold，提供额外的扩展方法支持
 *
 * 必须满足以下两个条件才会被成功注册：
 * 1. 被注册的对象或者方法必须是 public
 * 2. 对象必须是spring bean
 * @author victor-wu
 * @date 2024年4月3日
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Component
public @interface MoldObject {

    /**
     * 注册到spring 容器中的名称
     */
    @AliasFor(annotation = Component.class)
    String value() default "";


    /**
     * 注册范围
     * 默认是以 Object 注册，调用方式为 moldObject.hello()
     * @return
     */
    Scope[] scope() default {Scope.OBJECT, Scope.METHOD};

//    /**
//     * 调用的名称，如果不填写默认是类名的小驼峰命名法，例如：moldObject.hello()
//     * @return
//     */
//    String name() default "";


    /**
     * 注册选定的范围，被注册的对象或方法必须是公开的，否则都会被忽略
     */
    enum Scope {
        /**
         * 以标注对象注册，调用方式为 moldObject.hello()
         * 在被注册的对象下的方法不用再标记 @MoldMethod， 除非你想忽略某个方法的注册
         */
        OBJECT,
        /**
         * 检查对象下带有 @MoldMethod 注解的方法进行注册，调用方式为：hello()
         */
        METHOD
    }
}
