package cn.k7g.alloy.annotation;


import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 这是一个模板注解，提供快速的模板解析。通常用于消息通知，提示语，欢迎语等场景<br/>
 * 用法可以参考源码中的 TestMold2.java
 *
 * <br/>
 * 注意： <br/>
 * 1. 标记一个接口类为 @MoldContent 容器类 <br/>
 * 2. 在接口类上 类上标记的 @MoldContent 优先级低于方法上标记 <br/>
 * 3. 根据需要设置执行级别：execLevel，优先考虑安全级别的调用  <br/>
 * 4. 参数上标记 @MoldParam 表示需要转化对应的数据类型，如果没有标记当做常量处理 <br/>
 * 5. 需要 参数转换功能，例如时间格式化，金钱格式化等，参考 LinkVar 和 LinkDataProvide <br/>
 *
 * <br/>
 * 关于返回值：<br/>
 *       1. 优先返回 trigger 的执行结果，前提是 trigger 的返回值与 标注@MoldContent 的方法返回值一致<br/>
 *       2. 不满足条件1时，且 返回值是String，那么会返回 value() 模板的执行结果<br/>
 *       3. 不满足以上条件返回null<br/>
 * @author victor-wu
 * @date 2024年4月3日
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface MoldContent {
    String value() default "";

    Level execLevel() default Level.DEFAULT;

    /**
     * 调用被标记 @MoldContent 函数的时候，会直接触发外部命令，
     * value() 执行结果是 名为：_result 的 String 类型参数
     *
     *
     * <br/>
     * 例如：#{@messageService.send(_result)}
     * @return
     */
    String trigger() default "";


    enum Level {
        /**
         * 不受控制的调用，支持调用spring component，执行级别非常高，禁止向外暴露给普通用户
         */
        UNCONTROLLED,
        /**
         * 可以调用Mold内的方法
         */
        MIX_UNSAFE,
        /**
         * 只能Mold中的调用属性值
         */
        SAFE,
        /**
         * 默认是使用父类设置的执行级别， 如果父类没有设置则使用 SAFE 级别
         */
        DEFAULT,
    }
}
