package cn.k7g.alloy.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 在JSON 输出的时候  序列出更多的时间格式
 *
 * 支持 LocalDateTime，LocalDate，Date
 * @author victor-wu
 * @date 2024年4月3日
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface TimeExtra {
    /**
     * 显示时间间隔多久。会多标记出2个字段，
     *
     * duration = 1234（毫秒）
     * durationLabel = 3秒前，3分钟，3小时前，3天前（最大单位天）
     *
     * @return
     */
    boolean timeDuration() default false;
}
