package cn.k7g.alloy.utils;

/**
 * 时间工具类
 * @date  2021/2/5 下午1:46
 * @author victor-wu
 */
public class TimeUtil {
    public static final long DAY = 3600  * 24 * 1000;
    public static final long HOURS = 3600 * 1000;
    public static final long MINUTE = 60 * 1000;
    public static final long SECOND = 1000;


    /**
     * 计算时间差
     * @param duration  毫秒
     * @return 返回一个中文描述时间
     */
    public static String getDurationLabel(Long duration) {

        if (duration >= DAY) {
            return duration / DAY + "天前";
        }

        if (duration >= HOURS) {
            return duration / HOURS + "小时前";
        }

        if (duration >= MINUTE) {
            return duration / MINUTE + "分钟前";
        }

        if (duration >= SECOND) {
            return duration / SECOND + "秒前";
        }

        return "刚刚";
    }

    public static void main(String[] args) {
        System.out.println(getDurationLabel(System.currentTimeMillis() - (System.currentTimeMillis() - SECOND * 3)));
    }
}
