package cn.k7g.alloy.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 别名标识
 * @author victor-wu
 * @date 2024年4月3日
 */
@Target({ElementType.PARAMETER, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Label {
    /**
     * 字段的名称，一般是中文名
     * @return
     */
    String value();

    /**
     * 验证消息增强：
     *
     * <code>
     * @Label("姓名")
     * @NotEmpty
     * @Size(max = 25)
     * String name;
     * </code>
     *
     * 上诉代码验证不通过生成的提示为：
     * 姓名 不能为空
     * 姓名 长度最大不超过25个字
     *
     * enhanceVerifyMessage = true 会覆盖验证注解中的 message 信息
     *
     * @return
     */
    boolean enhanceVerifyMessage() default true;
}
