/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.mold.impl;

import cn.k7g.alloy.mold.BaseMold;
import cn.k7g.alloy.mold.impl.AbstractMoldService;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanExpressionContextAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelMoldService
extends AbstractMoldService {
    private static final Logger log = LoggerFactory.getLogger(SpelMoldService.class);
    final ExpressionParser expressionParser = new SpelExpressionParser();
    SimpleEvaluationContext simpleEvaluationContext;
    StandardEvaluationContext standardEvaluationContext;
    StandardEvaluationContext uncontrolledEvaluationContext;
    final MethodResolver methodResolver = (context, targetObject, name, argumentTypes) -> {
        try {
            AbstractMoldService.DelegateMethod method;
            if (targetObject instanceof AbstractMoldService.GlobalVal) {
                method = ((List)this.globalMethod.get(name)).stream().filter(o -> {
                    if (o.originMethod.getParameterCount() != argumentTypes.size()) {
                        return false;
                    }
                    for (int i = 0; i < o.originMethod.getParameterCount(); ++i) {
                        if (o.originMethod.getParameters()[i].getType().isAssignableFrom(((TypeDescriptor)argumentTypes.get(i)).getType())) continue;
                        return false;
                    }
                    return true;
                }).findFirst().orElse(null);
                if (method == null) {
                    throw new NoSuchMethodException("mold \u672a\u6ce8\u518c\u65b9\u6cd5: " + name);
                }
            } else {
                Class[] classes = argumentTypes.stream().map(o -> o.getType()).collect(Collectors.toList()).toArray(new Class[0]);
                Method m = targetObject.getClass().getMethod(name, classes);
                method = new AbstractMoldService.DelegateMethod(targetObject, m);
            }
            return new AbstractMoldService.DelegateExecutor(method);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    };

    @Override
    @PostConstruct
    public void init() {
        this.simpleEvaluationContext = new SimpleEvaluationContext.Builder(new PropertyAccessor[]{new ReflectivePropertyAccessor(), new MapAccessor()}).build();
        this.standardEvaluationContext = new StandardEvaluationContext();
        this.standardEvaluationContext.addPropertyAccessor((PropertyAccessor)new ReflectivePropertyAccessor());
        this.standardEvaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        this.standardEvaluationContext.addMethodResolver(this.methodResolver);
        this.uncontrolledEvaluationContext = new StandardEvaluationContext();
        this.uncontrolledEvaluationContext.addPropertyAccessor((PropertyAccessor)new ReflectivePropertyAccessor());
        this.uncontrolledEvaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        this.uncontrolledEvaluationContext.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
        this.uncontrolledEvaluationContext.addPropertyAccessor((PropertyAccessor)new BeanExpressionContextAccessor());
        this.uncontrolledEvaluationContext.addMethodResolver(this.methodResolver);
        this.uncontrolledEvaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.context));
    }

    @Override
    public Object createContent(BaseMold baseMold) {
        return this.exec((EvaluationContext)this.simpleEvaluationContext, baseMold);
    }

    @Override
    public Object createContentMixUnsafe(BaseMold baseMold) {
        return this.exec((EvaluationContext)this.standardEvaluationContext, baseMold);
    }

    @Override
    public Object createContentUncontrolled(BaseMold baseMold) {
        return this.exec((EvaluationContext)this.uncontrolledEvaluationContext, baseMold);
    }

    public Object exec(EvaluationContext evaluationContext, BaseMold baseMold) {
        AbstractMoldService.GlobalVal params = this.readyVar(baseMold);
        Object value = this.expressionParser.parseExpression(baseMold.getContent(), (ParserContext)new TemplateParserContext()).getValue(evaluationContext, (Object)params);
        if (log.isDebugEnabled()) {
            log.debug("mold\u6267\u884c\u7ed3\u679c\nmoldContent: {}  \nmoldParams: {}\nmodlResult: {} \n", new Object[]{baseMold.getContent(), params, value});
        }
        return value;
    }
}

