/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.model;

public class SortOrder
implements Comparable<SortOrder> {
    public static final long MAX_VALUE = 0x100000000L;
    public static final long MIN_VALUE = 0L;
    public static final long MID_VALUE = 0x100000L;
    public static final long INTERVAL_VALUE = 10000L;
    private final long value;
    public static final SortOrder MIN = new SortOrder(0L);
    public static final SortOrder MIDDLE = new SortOrder(0x100000L);

    public SortOrder() {
        this.value = 0L;
    }

    public SortOrder(long value) {
        this.value = value > 0x100000000L ? 0x100000000L : (value < 0L ? 0L : value);
    }

    public long longValue() {
        return this.value;
    }

    public SortOrder move(long value) {
        return new SortOrder(this.value + value);
    }

    public SortOrder moveBetween(SortOrder end) {
        long diff = Math.abs(this.longValue() - end.longValue());
        long newSort = diff / 2L + Math.min(this.longValue(), end.longValue());
        if (newSort == end.longValue() || newSort == this.longValue()) {
            return null;
        }
        return new SortOrder(newSort);
    }

    public SortOrder moveIncreaseInterval() {
        return new SortOrder(this.value + 10000L);
    }

    public SortOrder moveDeductInterval() {
        return new SortOrder(this.value - 10000L);
    }

    public boolean isMinimum() {
        return this.value == 0L;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public int compareTo(SortOrder o) {
        return Long.compare(o.longValue(), this.value);
    }

    public long getMinimumAvailableInterval(int size) {
        long diff = (this.value - 1L) / (long)size;
        return diff > 10000L ? 10000L : diff;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SortOrder)) {
            return false;
        }
        SortOrder o = (SortOrder)obj;
        return o.value == o.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }
}

