/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.ioc.processor;

import cn.k7g.alloy.annotation.IgnoreEmptyInvoke;
import cn.k7g.alloy.annotation.IgnoreEmptyParam;
import cn.k7g.alloy.autoconfiguration.EnableOptions;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnBean(value={EnableOptions.EnableIgnoreInvoke.class})
public class IgnoreInvokeAspect {
    private static final Logger log = LoggerFactory.getLogger(IgnoreInvokeAspect.class);

    @Around(value="@annotation(ignore)")
    public Object s(ProceedingJoinPoint joinPoint, IgnoreEmptyInvoke ignore) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Parameter[] parameters = method.getParameters();
        Object[] args = joinPoint.getArgs();
        int i = 0;
        for (Parameter parameter : parameters) {
            if (parameter.isAnnotationPresent(IgnoreEmptyParam.class)) {
                boolean valid = true;
                if (args[i] == null) {
                    valid = false;
                } else if (args[i].getClass().isArray() && ((Object[])args[i]).length == 0) {
                    valid = false;
                } else if (args[i] instanceof Collection && ((Collection)args[i]).isEmpty()) {
                    valid = false;
                }
                if (!valid) {
                    log.debug("{} # {} \u4e2d\u53c2\u6570 {} \u4e3a\u7a7a\uff0c\u5ffd\u7565\u6267\u884c", new Object[]{joinPoint.getTarget().getClass().getName(), signature.getName(), parameter});
                    return this.genDefaultReturnValue(method);
                }
            }
            ++i;
        }
        return joinPoint.proceed(joinPoint.getArgs());
    }

    private Object genDefaultReturnValue(Method method) {
        Class<?> returnType = method.getReturnType();
        if (Collection.class.isAssignableFrom(returnType)) {
            return new ArrayList();
        }
        return null;
    }
}

