/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.core.objectmapper;

import cn.k7g.alloy.annotation.ExpandFlag;
import cn.k7g.alloy.core.ext.FlagCode;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandFlagEnumSerializer
extends JsonSerializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(ExpandFlagEnumSerializer.class);
    private ExpandFlag expandFlag;

    public ExpandFlagEnumSerializer(ExpandFlag expandFlag) {
        this.expandFlag = expandFlag;
    }

    public void serialize(Object v, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        HashMap<String, Boolean> val = new HashMap<String, Boolean>();
        Set set = Optional.ofNullable((Set)v).orElse(new HashSet());
        try {
            FlagCode[] enums;
            Class value = this.expandFlag.value();
            Method valuesMethod = value.getMethod("values", new Class[0]);
            for (FlagCode item : enums = (FlagCode[])valuesMethod.invoke(null, new Object[0])) {
                val.put(item.name(), set.contains(item));
            }
            jsonGenerator.writeObject(val);
        }
        catch (Exception e) {
            log.error("ExpandFlagEnumSerializer error", (Throwable)e);
        }
    }
}

