/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.utils;

import cn.k7g.alloy.model.BetweenSortScope;
import cn.k7g.alloy.model.SortOrder;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;

public class SortOrderUtil {
    public static <T> SortOrder move(@Nullable SortOrder start, @Nullable SortOrder end, Supplier<List<T>> all, BiConsumer<T, SortOrder> setter, Function<List<T>, BetweenSortScope> reorderCompleted) {
        SortOrder sort;
        if (start == null && end == null) {
            throw new RuntimeException("start end \u4e0d\u53ef\u540c\u65f6\u4e3a null");
        }
        if (start != null && end != null) {
            sort = start.moveBetween(end);
            if (sort.isMinimum()) {
                BetweenSortScope betweenSortScope = SortOrderUtil.fixGroupSort(all, setter, reorderCompleted);
                betweenSortScope.assertVerify();
                sort = SortOrderUtil.move(betweenSortScope.getStart(), betweenSortScope.getEnd(), all, setter, reorderCompleted);
            }
        } else if (start != null) {
            sort = start.moveDeductInterval();
            if (sort.equals(start)) {
                BetweenSortScope betweenSortScope = SortOrderUtil.fixGroupSort(all, setter, reorderCompleted);
                betweenSortScope.assertVerify();
                sort = SortOrderUtil.move(betweenSortScope.getStart(), betweenSortScope.getEnd(), all, setter, reorderCompleted);
            }
        } else if (end != null) {
            sort = end.moveIncreaseInterval();
            if (sort.equals(end)) {
                BetweenSortScope betweenSortScope = SortOrderUtil.fixGroupSort(all, setter, reorderCompleted);
                betweenSortScope.assertVerify();
                sort = SortOrderUtil.move(betweenSortScope.getStart(), betweenSortScope.getEnd(), all, setter, reorderCompleted);
            }
        } else {
            sort = SortOrder.MIDDLE;
        }
        return sort;
    }

    private static <T> BetweenSortScope fixGroupSort(Supplier<List<T>> all, BiConsumer<T, SortOrder> setter, Function<List<T>, BetweenSortScope> reorderCompleted) {
        long max = 429496L;
        List<T> list = all.get();
        if (max < (long)list.size()) {
            throw new RuntimeException("\u8d85\u8fc7\u6700\u5927\u652f\u6301\u5143\u7d20\u91cf\uff1a" + max);
        }
        SortOrder sort = SortOrder.MIN;
        for (T item : list) {
            setter.accept(item, sort.moveIncreaseInterval());
        }
        return reorderCompleted.apply(list);
    }
}

