/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.ioc.processor;

import cn.k7g.alloy.core.objectmapper.BigIntegerSerializer;
import cn.k7g.alloy.core.objectmapper.CodeLabelEnumAnnotationIntrospector;
import cn.k7g.alloy.core.objectmapper.EnumSerializer;
import cn.k7g.alloy.core.objectmapper.GlobalDateFormatter;
import cn.k7g.alloy.core.objectmapper.LongToString;
import cn.k7g.alloy.core.objectmapper.SortOrderDeserializer;
import cn.k7g.alloy.core.objectmapper.SortOrderSerializer;
import cn.k7g.alloy.core.objectmapper.Timestamp;
import cn.k7g.alloy.core.objectmapper.TimestampSerializer;
import cn.k7g.alloy.model.SortOrder;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.math.BigInteger;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class EnhanceObjectMapperProcess
implements BeanPostProcessor {
    boolean enhanceObjectMapper;

    public EnhanceObjectMapperProcess(boolean enhanceObjectMapper) {
        this.enhanceObjectMapper = enhanceObjectMapper;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ObjectMapper && this.enhanceObjectMapper) {
            this.enhanceObjectMapper0((ObjectMapper)bean);
        }
        return bean;
    }

    private void enhanceObjectMapper0(ObjectMapper objectMapper) {
        AnnotationIntrospector annotationIntrospector = objectMapper.getSerializationConfig().getAnnotationIntrospector();
        AnnotationIntrospector pair = AnnotationIntrospector.pair((AnnotationIntrospector)annotationIntrospector, (AnnotationIntrospector)new CodeLabelEnumAnnotationIntrospector());
        objectMapper.setAnnotationIntrospector(pair);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Enum.class, (JsonSerializer)new EnumSerializer());
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        module.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        module.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        module.addSerializer(Timestamp.class, (JsonSerializer)new TimestampSerializer());
        module.addSerializer(SortOrder.class, (JsonSerializer)new SortOrderSerializer());
        module.addSerializer(BigInteger.class, (JsonSerializer)new BigIntegerSerializer());
        module.addSerializer(Long.class, (JsonSerializer)new LongToString());
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        module.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        module.addDeserializer(SortOrder.class, (JsonDeserializer)new SortOrderDeserializer());
        objectMapper.registerModule((Module)module);
        objectMapper.setDateFormat((DateFormat)new GlobalDateFormatter());
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

