/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.ioc.processor;

import cn.k7g.alloy.autoconfiguration.EnableOptions;
import cn.k7g.alloy.expose.WebExceptionResponseHandler;
import cn.k7g.alloy.utils.AlloyUtils;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.nio.file.AccessDeniedException;
import java.util.stream.Collectors;
import javax.security.auth.login.AccountExpiredException;
import javax.validation.ConstraintViolationException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MissingRequestValueException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@RestControllerAdvice
@ConditionalOnBean(value={EnableOptions.EnhanceExceptionMessage.class})
public class EnhanceExceptionResponse {
    private static final Logger log = LoggerFactory.getLogger(EnhanceExceptionResponse.class);
    @Autowired
    private WebExceptionResponseHandler handler;
    @Autowired
    private MultipartProperties multipartProperties;

    @ExceptionHandler(value={AccessDeniedException.class})
    public Object handleAuthorizationException(AccessDeniedException e) {
        return this.handler.handle("\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743", e);
    }

    @ExceptionHandler(value={AccountExpiredException.class})
    public Object handleAccountExpiredException(AccountExpiredException e) {
        return this.handler.handle("\u767b\u5f55\u5931\u6548\u4e86", e);
    }

    @ExceptionHandler(value={Exception.class})
    public Object handleException(Exception e) {
        return this.handler.handle("\u7cfb\u7edf\u9519\u8bef", e);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public Object handleException(MethodArgumentTypeMismatchException e) {
        String msg = String.format("\u53c2\u6570\u7c7b\u578b\u9519\u8bef: [%s] - %s  \u8be6\u7ec6\u63cf\u8ff0\uff1a %s", e.getName(), e.getParameter().getParameterType().getSimpleName(), e.getMessage());
        return this.handler.handle(msg, (Exception)e);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Object handleException(ConstraintViolationException e) {
        StringBuilder sb = new StringBuilder();
        e.getConstraintViolations().forEach(o -> {
            String fieldName = AlloyUtils.getFieldAlias(o);
            sb.append(fieldName).append(" ").append(o.getMessage()).append("\n");
        });
        return this.handler.handle(sb.toString(), (Exception)e);
    }

    @ExceptionHandler(value={BindException.class})
    public Object validatedBindException(BindException e) {
        String errorToString = AlloyUtils.getErrorToString((BindingResult)e);
        return this.handler.handle(errorToString, (Exception)e);
    }

    @ExceptionHandler(value={MissingRequestValueException.class})
    public Object missingServletRequestParameterExceptionHandler(MissingRequestValueException e) {
        String message;
        if (e instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException e1 = (MissingServletRequestParameterException)e;
            message = String.format("\u7f3a\u5c11query\u53c2\u6570 [%s] ", e1.getParameterName());
        } else {
            message = e.getMessage();
        }
        return this.handler.handle(message, (Exception)e);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Object maxUploadSizeExceededException(MaxUploadSizeExceededException e) {
        long min = Math.min(this.multipartProperties.getMaxFileSize().toBytes(), this.multipartProperties.getMaxRequestSize().toBytes());
        return this.handler.handle("\u6587\u4ef6\u6700\u5927\u652f\u6301\uff1a" + FileUtils.byteCountToDisplaySize((long)min), (Exception)e);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Object invalidFormatException(HttpMessageNotReadableException e) {
        if (e.getCause() instanceof InvalidFormatException) {
            InvalidFormatException cause = (InvalidFormatException)e.getCause();
            String fieldPath = cause.getPath().stream().map(o -> o.getFieldName()).filter(o -> o != null).collect(Collectors.joining("."));
            return this.handler.handle(String.format("%s \u662f %s \u7c7b\u578b\uff0c\u65e0\u6cd5\u8f93\u5165\u503c\u4e3a\uff1a%s", fieldPath, cause.getTargetType().getSimpleName(), cause.getValue().toString()), (Exception)e);
        }
        return this.handler.handle(e.getMessage(), (Exception)e);
    }
}

