/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.utils;

import cn.k7g.alloy.model.DiffResult;
import cn.k7g.alloy.model.DiffUnchangedFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;

public class DiffUtil {
    public static <K, V> DiffResult<V> diffNewOld(Map<K, V> newDataMap, Map<K, V> oldDataMap, @Nullable DiffUnchangedFunction<V, V, V> unchanged) {
        List addedList = newDataMap.entrySet().stream().filter(item -> !oldDataMap.containsKey(item.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        ArrayList<V> deleteList = new ArrayList<V>();
        ArrayList<V> unchangedList = new ArrayList<V>();
        ArrayList<V> changedList = new ArrayList<V>();
        for (Map.Entry<K, V> old : oldDataMap.entrySet()) {
            if (newDataMap.containsKey(old.getKey())) {
                if (unchanged != null) {
                    V apply = unchanged.apply(newDataMap.get(old.getKey()), old.getValue());
                    if (apply == null) {
                        unchangedList.add(old.getValue());
                        continue;
                    }
                    changedList.add(apply);
                    continue;
                }
                unchangedList.add(old.getValue());
                continue;
            }
            deleteList.add(old.getValue());
        }
        DiffResult<Object> result = new DiffResult<Object>();
        result.setAddList(addedList);
        result.setDeleteList(deleteList);
        result.setUnchangedList(unchangedList);
        result.setChangedList(changedList);
        return result;
    }

    public static <K, V> DiffResult<V> diffNewOld(List<V> newDataList, List<V> oldDataList, Function<V, K> key, @Nullable DiffUnchangedFunction<V, V, V> unchanged) {
        Map<K, Object> newDataMap = newDataList.stream().collect(Collectors.toMap(key, v -> v, (o1, o2) -> o2));
        Map<K, Object> oldDataMap = oldDataList.stream().collect(Collectors.toMap(key, v -> v, (o1, o2) -> o2));
        return DiffUtil.diffNewOld(newDataMap, oldDataMap, unchanged);
    }
}

