/*
 * Decompiled with CFR 0.152.
 */
package cn.k7g.alloy.expose;

import cn.k7g.alloy.exception.AlloyContentDecodeException;
import cn.k7g.alloy.exception.AlloyContentEncodeException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AlloyContentHandler {
    public static final Class[] BASIC_TYPE = new Class[]{Long.class, String.class, Integer.class, Long.TYPE, Integer.TYPE, Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Short.class, Short.TYPE};
    @Autowired
    private ObjectMapper objectMapper;

    public abstract byte[] anonymousOwnerKey();

    public abstract byte[] ownerKey();

    public abstract boolean isLogin();

    public abstract RuntimeException throwNotLoginException();

    public byte[] getKey() {
        return this.getKey(false);
    }

    public byte[] getKey(boolean forceAny) {
        byte[] key;
        byte[] byArray = key = !forceAny && this.isLogin() ? this.ownerKey() : this.anonymousOwnerKey();
        if (key.length > 32) {
            throw new RuntimeException("alloy key \u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
        }
        if (key.length == 16 || key.length == 24 || key.length == 32) {
            return key;
        }
        if (key.length < 16) {
            return this.fill(key, 16);
        }
        if (key.length < 24) {
            return this.fill(key, 24);
        }
        return this.fill(key, 32);
    }

    public byte[] fill(byte[] key, int len) {
        byte[] nk = new byte[len];
        System.arraycopy(key, 0, nk, 0, key.length);
        for (int i = key.length; i < nk.length; ++i) {
            nk[i] = 48;
        }
        return nk;
    }

    public static String decode(String value, byte[] key) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, secretKeySpec);
            byte[] decryptedBytes = cipher.doFinal(Base64.getUrlDecoder().decode(value));
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new AlloyContentDecodeException("\u65e0\u6548\u7684alloy content", e);
        }
    }

    public static String encode(String originId, byte[] key) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKeySpec);
            byte[] encryptedBytes = cipher.doFinal(originId.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().encodeToString(encryptedBytes);
        }
        catch (Exception e) {
            throw new AlloyContentEncodeException("\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public <T> T decodeObject(String content, Class<T> dataType) throws JsonProcessingException {
        String originContent;
        try {
            originContent = AlloyContentHandler.decode(content, this.getKey());
        }
        catch (Exception e) {
            originContent = AlloyContentHandler.decode(content, this.getKey(true));
        }
        return (T)this.objectMapper.readValue(originContent, dataType);
    }

    public String encodeObject(Object o) throws JsonProcessingException {
        return AlloyContentHandler.encode(this.objectMapper.writeValueAsString(o), this.getKey());
    }
}

