package cn.k7g.alloy.mold.var;

import lombok.Data;

import java.io.Serializable;

/**
 * 数据变量
 * 声明变量提供给模板功能使用
 */
@Data
public abstract class AbsVar {
    /**
     * 提供实际的数据类型
     */
    private Class dataCls;
    /**
     * 映射到的变量名称
     */
    private String varName;
    /**
     * 默认第一个参数方便使用，
     * 如果有更多的参数，自行在子类中扩展
     */
    private Serializable firstParam;

    public AbsVar(Class dataCls, String varName, Serializable firstParam) {
        this.dataCls = dataCls;
        this.varName = varName;
        this.firstParam = firstParam;
    }
}
