package cn.k7g.alloy.mold;

import cn.k7g.alloy.mold.var.AbsVar;
import cn.k7g.alloy.mold.var.ConstVar;
import lombok.Data;
import lombok.Getter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 基础模具
 */
@Getter
public class BaseMold {

    private String content;
    private Map<String, AbsVar> model = new HashMap<>();



    /**
     * 设置 content 中可用的变量
     */
    public BaseMold addVar(AbsVar var) {
        model.put(var.getVarName(), var);
        return this;
    }

    public BaseMold addConstVar(String varName, Serializable var) {
        model.put(varName, new ConstVar(varName, var));
        return this;
    }

    /**
     * 设置文本内容，#{变量名}， 变量名中可用的属性 参考 VarType, 可以使用spel表达式
     * @param content
     */
    public BaseMold setContent(String content) {
        this.content = content;
        return this;
    }
}
