package cn.k7g.alloy.ioc.processor;

import cn.k7g.alloy.ioc.conversion.AlloyContentConverter;
import cn.k7g.alloy.ioc.conversion.AlloyConversionService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.web.format.DateTimeFormatters;
import org.springframework.boot.autoconfigure.web.format.WebConversionService;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;

public class EnhanceAlloyConversionServiceProcess implements BeanPostProcessor {

    @Autowired
    private WebMvcProperties mvcProperties;
    @Autowired
    private AlloyContentConverter alloyContentConverter;

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof WebConversionService) {
            WebMvcProperties.Format format = mvcProperties.getFormat();
            WebConversionService conversionService = new AlloyConversionService(new DateTimeFormatters()
                    .dateFormat(format.getDate()).timeFormat(format.getTime()).dateTimeFormat(format.getDateTime()));

            conversionService.addConverter(alloyContentConverter);

            return conversionService;
        }
        return bean;
    }


}
