package cn.k7g.alloy.expose;

import cn.k7g.alloy.mold.var.AbsVar;

/**
 * 数据提供, 实现此接口的子类必须是一个 spring component
 */
public interface DataProvider<R> {
    /**
     * 是否支持此类型，若不支持继续匹配其他的提供器
     * @param var 声明的变量
     * @return 是否支持变量
     */
    boolean supports(AbsVar var);

    /**
     * 使用当前实现的提供器，将AbsVar 转换成实际的数据类型。
     * 实现的 DataProvider 必须是一个 Spring 组件
     * @param var 声明的变量
     * @return 返回实际数据
     */
    R get(AbsVar var);
}
