package cn.k7g.alloy.core.objectmapper;

import cn.k7g.alloy.annotation.AlloyContent;
import cn.k7g.alloy.expose.AlloyContentHandler;
import cn.k7g.alloy.ioc.SpringUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import java.io.IOException;

public class AlloyContentDeserializer extends JsonDeserializer<Object> {
    private AlloyContent alloyContent;
    private AlloyContentHandler alloyContentHandler;

    private Class dataType;

    public AlloyContentDeserializer(AlloyContent alloyContent, Class dataType) {
        this.alloyContent = alloyContent;
        this.dataType = dataType;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        AlloyContentHandler handler = getHandler();
        return handler.decodeObject(jsonParser.getValueAsString(), dataType);
    }

    public AlloyContentHandler getHandler() {
        if (alloyContentHandler == null) {
            alloyContentHandler = SpringUtil.getBean(AlloyContentHandler.class);
        }
        if (alloyContentHandler == null) {
            // 不允许在初始化未完成的时候调用，对于mvc来说这不会触发
            throw new RuntimeException("系统尚未初始化完成");
        }
        return alloyContentHandler;
    }
}
