package cn.k7g.alloy.autoconfiguration;


import org.springframework.context.annotation.Import;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Import(AlloyAutoConfigurationSelector.class)
public @interface EnableAlloyAutoConfiguration {

    /**
     * 增强 ObjectMapper 配置
     */
    boolean enableEnhanceObjectMapper() default false;

    /**
     * 增强异常消息提示，将英文错误代码映射为中文
     */
    boolean enableEnhanceExceptionMessage() default false;

    /**
     * 启用忽略执行
     * 开启需要依赖 aspectjweaver
     *
     * <code>
 *             <dependency>
     *             <groupId>org.aspectj</groupId>
     *             <artifactId>aspectjweaver</artifactId>
     *         </dependency>
     * </code>
     */
    boolean enableIgnoreInvoke() default false;

    /**
     * 扫描 @MoldContent 注解所在的包
     * @return
     */
    String[] moldBasePackages() default {};


}
