package cn.k7g.alloy.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 展开标记
 *
 * 将 Set<Flag> 展开为单一属性，Flag 必须是一个枚举类型，并实现了 FlagCode 接口
 *
 * 例如 Flag 枚举中有 DELETE，OPEN，VISIBLE
 *      User 数据下有一个 Set<Flag> 被标记展开的对象将会变成
 *      user ｛
 *          flag: {
 *              DELETE: true,  Set中存在的枚举将会显示为 true 不存在将会显示为 false
 *              OPEN: false,
 *              VIABLE: true，
 *              VIABLELabel: "可见的"，  如果开启 @ExpandFlag（label = true） 则会显示别名属性
 *          }
 *      ｝
 *
 *
 * author: wzx
 * time: 2022/7/27 下午3:09
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ExpandFlag {
    /**
     * 是否显示 label 名称
     * @return
     */
    boolean label() default false;

    /**
     * 指向的注解类型例如
     * @return
     */
    Class value();
}
