package cn.k7g.alloy.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * <pre>注解CODE解释
 * 用法介绍：
 * {@code
 *    @CodeLabelEnum(AddMethod.class)
 *    private Integer addMethod;
 * }
 * 需要被映射的 enum类型 必须包含  code 和 label 两个属性 与 getLabel getCode 两个方法
 *
 * 被注解的 变量值类型要与 code 值类型一致
 *
 * 注： 在序列成JSON值的时候 会根据变量名 新增出 变量名Label 字段
 * 例如 ： addMethodLabel
 * {
 *     addMethod：1
 *     addMethodLabel： 来自微信好友
 * }
 * </pre>
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface CodeLabelEnum {
    /**
     * 指向的注解类型例如
     * @return
     */
    Class value();
}
