package cn.jslim.mybatis;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.mybatisflex.core.tenant.TenantFactory;

import cn.jslim.starter.context.TenantContextHolder;
import cn.jslim.starter.source.YamlPropertySource;

@Configuration
@YamlPropertySource("classpath:mybatis.yml")
public class MyBatisConfiguration {
	
	@Bean
	TenantFactory tenantFactory() {
		return new TenantFactory() {
			@Override
			public Object[] getTenantIds() {
				Long tenantId = TenantContextHolder.getTenantId();
				if (null == tenantId) {
					return null;
				}
				return new Object[] { tenantId };
			}
		};
	}
	
}