package cn.jslim.mybatis.mapper;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.query.QueryWrapper;

import cn.jslim.mybatis.entity.BasicEntity;
import cn.jslim.toolkit.domain.Page;

public interface BasicMapper<T extends BasicEntity> extends BaseMapper<T> {

	default Page<T> selectPage(Page<T> page, QueryWrapper wrapper) {
		if (null == page) {
			page = Page.of();
		}
		long pageNumber = (page.getStart() / page.getLimit()) + 1;

		com.mybatisflex.core.paginate.Page<T> temp = new com.mybatisflex.core.paginate.Page<>();
		temp.setPageSize(page.getLimit());
		temp.setPageNumber(pageNumber);
		temp = this.paginate(temp, wrapper);

		page.setData(temp.getRecords());
		page.setTotal(temp.getTotalRow());

		return page;
	}

}