package cn.jslim.mybatis.entity;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mybatisflex.annotation.Column;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class BasicDataEntity extends BasicEntity {

	private static final long serialVersionUID = 1L;

	@JsonIgnore
	@Column(value = "data_version", version = true)
	private Long dataVersion;

	@JsonIgnore
	@Column(value = "data_deleted", isLogicDelete = true)
	private Boolean dataDeleted;

	@Column(value = "data_created_time", onInsertValue = "now()")
	private LocalDateTime dataCreatedTime;

	@Column(value = "data_updated_time", onInsertValue = "now()", onUpdateValue = "now()")
	private LocalDateTime dataUpdatedTime;
	
}