/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.module.upload.toolkit.support;

import cn.jslim.basic.toolkit.domain.R;
import cn.jslim.module.upload.domain.ObtainFileResult;
import cn.jslim.module.upload.domain.UploadChunk;
import cn.jslim.module.upload.domain.UploadChunkResult;
import cn.jslim.module.upload.domain.UploadFileResult;
import cn.jslim.module.upload.domain.VerifyChunk;
import cn.jslim.module.upload.domain.VerifyChunkResult;
import cn.jslim.module.upload.toolkit.FileManager;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractFileManager
implements FileManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractFileManager.class);

    @Override
    public R<Void> deleteFile(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return R.failure((String)"\u6587\u4ef6\u8def\u5f84\u6709\u8bef");
        }
        try {
            return this.doDeleteFile(filePath);
        }
        catch (Exception e) {
            log.error("delete file failed : {}", (Object)e.getMessage(), (Object)e);
            return R.failure((String)"\u6587\u4ef6\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public R<UploadFileResult> uploadFile(MultipartFile file) {
        if (null == file) {
            return R.failure((String)"\u6587\u4ef6\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        try {
            return this.doUploadFile(file);
        }
        catch (Exception e) {
            log.error("upload file failed : {}", (Object)e.getMessage(), (Object)e);
            return R.failure((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @Override
    public R<ObtainFileResult> obtainFile(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return R.failure((String)"\u6587\u4ef6\u8def\u5f84\u6709\u8bef");
        }
        try {
            return this.doObtainFile(filePath);
        }
        catch (Exception e) {
            log.error("obtain file failed : {}", (Object)e.getMessage(), (Object)e);
            return R.failure((String)"\u6587\u4ef6\u83b7\u53d6\u5931\u8d25");
        }
    }

    @Override
    public R<UploadChunkResult> uploadChunk(MultipartFile chunk, UploadChunk params) {
        if (null == chunk) {
            return R.failure((String)"\u6587\u4ef6\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (null == params) {
            return R.failure((String)"\u6587\u4ef6\u5206\u7247\u53c2\u6570\u6709\u8bef");
        }
        try {
            return this.doUploadChunk(chunk, params);
        }
        catch (Exception e) {
            log.error("upload chunk failed : {}", (Object)e.getMessage(), (Object)e);
            return R.failure((String)"\u5206\u7247\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @Override
    public R<VerifyChunkResult> verifyChunk(VerifyChunk chunk) {
        if (null == chunk) {
            return R.failure((String)"\u6587\u4ef6\u5206\u7247\u53c2\u6570\u6709\u8bef");
        }
        try {
            return this.doVerifyChunk(chunk);
        }
        catch (Exception e) {
            log.error("verify chunk failed : {}", (Object)e.getMessage(), (Object)e);
            return R.failure((String)"\u6587\u4ef6\u5206\u7247\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    protected String newFileName(String fileName) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return uuid;
        }
        String type = FilenameUtils.getExtension((String)fileName);
        if (StringUtils.isBlank((CharSequence)type)) {
            return uuid;
        }
        return String.format("%s.%s", uuid, type);
    }

    protected abstract R<Void> doDeleteFile(String var1) throws Exception;

    protected abstract R<UploadFileResult> doUploadFile(MultipartFile var1) throws Exception;

    protected abstract R<ObtainFileResult> doObtainFile(String var1) throws Exception;

    protected abstract R<UploadChunkResult> doUploadChunk(MultipartFile var1, UploadChunk var2) throws Exception;

    protected abstract R<VerifyChunkResult> doVerifyChunk(VerifyChunk var1) throws Exception;
}

