/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.module.upload.toolkit;

import cn.jslim.basic.toolkit.domain.LogicException;
import cn.jslim.basic.toolkit.domain.ResultStatus;
import cn.jslim.module.upload.toolkit.FileChannel;
import cn.jslim.module.upload.toolkit.FileManager;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class FileManagerFactory {
    @Resource
    private ApplicationContext applicationContext;

    public List<FileChannel> getSupportedChannelList() {
        Map mapping = this.applicationContext.getBeansOfType(FileChannel.class);
        if (null == mapping || mapping.isEmpty()) {
            return List.of();
        }
        return new ArrayList<FileChannel>(mapping.values());
    }

    public FileChannel getFileChannel(String channel) {
        if (StringUtils.isBlank((CharSequence)channel)) {
            throw LogicException.of((ResultStatus)ResultStatus.PARAMETER_EMPTY);
        }
        Map mapping = this.applicationContext.getBeansOfType(FileChannel.class);
        if (null != mapping && mapping.size() > 0) {
            for (Map.Entry entry : mapping.entrySet()) {
                FileChannel fileChannel = (FileChannel)entry.getValue();
                if (!fileChannel.getCode().equals(channel)) continue;
                return fileChannel;
            }
        }
        throw new UnsupportedOperationException("Unsupported file channel : " + channel);
    }

    public FileManager getFileManager(String channel) {
        FileChannel fileChannel = this.getFileChannel(channel);
        return this.getFileManager(fileChannel);
    }

    public FileManager getFileManager(FileChannel fileChannel) {
        if (null == fileChannel) {
            throw LogicException.of((ResultStatus)ResultStatus.PARAMETER_EMPTY);
        }
        String beanName = fileChannel.getFileManagerBeanName();
        try {
            return (FileManager)this.applicationContext.getBean(beanName, FileManager.class);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Unsupported file channel : " + fileChannel.getCode());
        }
    }
}

