/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.module.upload.minio.toolkit;

import cn.jslim.basic.toolkit.domain.R;
import cn.jslim.module.upload.domain.ObtainFileResult;
import cn.jslim.module.upload.domain.UploadChunk;
import cn.jslim.module.upload.domain.UploadChunkResult;
import cn.jslim.module.upload.domain.UploadFileResult;
import cn.jslim.module.upload.domain.VerifyChunk;
import cn.jslim.module.upload.domain.VerifyChunkResult;
import cn.jslim.module.upload.minio.toolkit.MinioFileChannel;
import cn.jslim.module.upload.toolkit.FileChannel;
import cn.jslim.module.upload.toolkit.support.AbstractFileManager;
import com.alibaba.fastjson2.JSONObject;
import io.minio.BucketExistsArgs;
import io.minio.ComposeObjectArgs;
import io.minio.ComposeSource;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.messages.Item;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioFileManager
extends AbstractFileManager {
    @Resource
    private MinioFileChannel minioFileChannel;

    public void writeFile(String fileName, String filePath, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject formConfig = this.minioFileChannel.getFormValues();
        String bucket = this.getBucket(formConfig);
        String preview = this.getPreview(formConfig);
        String path = String.format("%s/%s%s", preview, bucket, filePath);
        response.sendRedirect(path);
    }

    public FileChannel getFileChannel() {
        return this.minioFileChannel;
    }

    protected R<Void> doDeleteFile(String filePath) throws Exception {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        return R.success();
    }

    protected R<UploadFileResult> doUploadFile(MultipartFile file) throws Exception {
        JSONObject formConfig = this.minioFileChannel.getFormValues();
        String rawFileName = file.getOriginalFilename();
        String filePath = this.getFilePath(rawFileName, formConfig);
        String newFileName = rawFileName;
        Boolean nameChange = formConfig.getBoolean("nameChange");
        if (null != nameChange && nameChange.booleanValue()) {
            newFileName = this.newFileName(rawFileName);
        }
        String newFilePath = String.format("%s/%s", filePath, newFileName);
        String bucket = this.getBucket(formConfig);
        MinioClient minioClient = this.getMinioClient(formConfig);
        this.checkBucket(minioClient, bucket);
        minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(newFilePath)).stream(file.getInputStream(), file.getSize(), -1L).contentType(file.getContentType()).build());
        UploadFileResult result = new UploadFileResult();
        result.setFileContentType(file.getContentType());
        result.setFileLength(Long.valueOf(file.getSize()));
        result.setFileName(newFileName);
        result.setFilePath(newFilePath);
        result.setFileType(FilenameUtils.getExtension((String)newFileName));
        result.setOriginalFileName(file.getOriginalFilename());
        return R.success((Object)result);
    }

    protected R<ObtainFileResult> doObtainFile(String filePath) throws Exception {
        JSONObject formConfig = this.minioFileChannel.getFormValues();
        String bucket = this.getBucket(formConfig);
        MinioClient minioClient = this.getMinioClient(formConfig);
        GetObjectResponse response = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(filePath)).build());
        byte[] data = response.readAllBytes();
        ObtainFileResult result = new ObtainFileResult();
        result.setFileName(FilenameUtils.getName((String)filePath));
        result.setFilePath(filePath);
        result.setFileData(data);
        return R.success((Object)result);
    }

    protected R<UploadChunkResult> doUploadChunk(MultipartFile chunk, UploadChunk params) throws Exception {
        JSONObject formConfig = this.minioFileChannel.getFormValues();
        String bucket = this.getBucket(formConfig);
        String chunkPath = this.getChunkPath(formConfig);
        MinioClient minioClient = this.getMinioClient(formConfig);
        String chunkPathFile = chunkPath + File.separator + params.getFileDigest() + File.separator + params.getChunkIndex();
        UploadChunkResult result = new UploadChunkResult();
        result.setFileDigest(params.getFileDigest());
        try {
            minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(chunkPathFile)).stream(chunk.getInputStream(), chunk.getSize(), -1L).contentType(params.getFileContentType()).build());
        }
        catch (Exception e) {
            result.setUploadStatus(Integer.valueOf(3));
            result.setUploadMessage("\u5206\u7247\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            return R.success((Object)result);
        }
        if (this.isAllChunksUploaded(params.getFileDigest(), chunkPath, params.getChunkCount(), bucket, minioClient)) {
            try {
                String filePath = this.getFilePath(params.getFileName(), formConfig);
                String newFileName = params.getFileName();
                Boolean nameChange = formConfig.getBoolean("nameChange");
                if (null != nameChange && nameChange.booleanValue()) {
                    newFileName = this.newFileName(params.getFileName());
                }
                String newFilePath = String.format("%s/%s", filePath, newFileName);
                ArrayList<ComposeSource> sources = new ArrayList<ComposeSource>();
                Object prefix = chunkPath + File.separator + params.getFileDigest();
                if (((String)prefix).startsWith("/")) {
                    prefix = ((String)prefix).substring(1);
                }
                Set<String> names = this.getUploadedChunksNames(chunkPath, params.getFileDigest(), bucket, minioClient);
                for (String name : names) {
                    ComposeSource cs = (ComposeSource)((ComposeSource.Builder)((ComposeSource.Builder)ComposeSource.builder().bucket(bucket)).object(name)).build();
                    sources.add(cs);
                }
                sources.sort((a, b) -> {
                    Integer intA = Integer.parseInt(FilenameUtils.getName((String)a.object()));
                    Integer intB = Integer.parseInt(FilenameUtils.getName((String)b.object()));
                    return intA.compareTo(intB);
                });
                minioClient.composeObject((ComposeObjectArgs)((ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)ComposeObjectArgs.builder().bucket(bucket)).legalHold(false)).object(newFilePath)).sources(sources).build());
                try {
                    Thread.sleep(100L);
                    for (String name : names) {
                        minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(File.separator + name)).build());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                result.setFileLength(params.getFileLength());
                result.setFilePath(newFilePath);
                result.setFileType(FilenameUtils.getExtension((String)newFilePath));
                result.setFileName(params.getFileName());
                result.setUploadStatus(Integer.valueOf(2));
                result.setUploadMessage("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
                return R.success((Object)result);
            }
            catch (Exception e) {
                e.printStackTrace();
                result.setUploadStatus(Integer.valueOf(3));
                result.setUploadMessage("\u5206\u7247\u6587\u4ef6\u5408\u5e76\u5931\u8d25");
                return R.success((Object)result);
            }
        }
        result.setUploadStatus(Integer.valueOf(1));
        result.setUploadMessage("\u6587\u4ef6\u4e0a\u4f20\u4e2d");
        return R.success((Object)result);
    }

    protected R<VerifyChunkResult> doVerifyChunk(VerifyChunk chunk) throws Exception {
        JSONObject formConfig = this.minioFileChannel.getFormValues();
        String bucket = this.getBucket(formConfig);
        String chunkPath = this.getChunkPath(formConfig);
        MinioClient minioClient = this.getMinioClient(formConfig);
        VerifyChunkResult result = new VerifyChunkResult();
        result.setFileDigest(chunk.getFileDigest());
        result.setUploadedChunks(this.getUploadedChunks(chunkPath, chunk.getFileDigest(), bucket, minioClient));
        return R.success((Object)result);
    }

    private boolean isAllChunksUploaded(String fileDigest, String chunkPath, Long chunkSize, String bucket, MinioClient minioClient) throws Exception {
        Set<Integer> uploadedChunks = this.getUploadedChunks(chunkPath, fileDigest, bucket, minioClient);
        return (long)uploadedChunks.size() == chunkSize;
    }

    private Set<Integer> getUploadedChunks(String chunkPath, String fileDigest, String bucket, MinioClient minioClient) throws Exception {
        return this.getUploadedChunksNames(chunkPath, fileDigest, bucket, minioClient).stream().map(name -> {
            String val = FilenameUtils.getName((String)name);
            return Integer.parseInt(val);
        }).collect(Collectors.toSet());
    }

    private Set<String> getUploadedChunksNames(String chunkPath, String fileDigest, String bucket, MinioClient minioClient) throws Exception {
        HashSet<String> chunks = new HashSet<String>();
        Object chunkPathFile = chunkPath + File.separator + fileDigest + File.separator;
        if (((String)chunkPathFile).startsWith("/")) {
            chunkPathFile = ((String)chunkPathFile).substring(1);
        }
        Iterable iterable = minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucket)).prefix((String)chunkPathFile).build());
        for (Result r : iterable) {
            Item i = (Item)r.get();
            chunks.add(i.objectName());
        }
        return chunks;
    }

    private void checkBucket(MinioClient minioClient, String bucket) throws Exception {
        if (!minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build())) {
            minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucket)).build());
        }
    }

    private String getChunkPath(JSONObject formConfig) {
        return formConfig.getString("pathChunk");
    }

    private String getBucket(JSONObject formConfig) {
        return formConfig.getString("bucketKey");
    }

    private String getPreview(JSONObject formConfig) {
        return formConfig.getString("previewUrl");
    }

    private MinioClient getMinioClient(JSONObject formConfig) {
        String endpoint = formConfig.getString("addressUrl");
        String accessKey = formConfig.getString("accessKey");
        String secretKey = formConfig.getString("secretKey");
        return MinioClient.builder().endpoint(endpoint).credentials(accessKey, secretKey).build();
    }

    private String getFilePath(String fileName, JSONObject formConfig) {
        String fileType;
        String root = formConfig.getString("pathRoot");
        Boolean pathTimeEnabled = formConfig.getBoolean("pathTimeEnabled");
        Boolean pathTypeEnabled = formConfig.getBoolean("pathTypeEnabled");
        String path = root;
        if (null != pathTimeEnabled && pathTimeEnabled.booleanValue()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            path = String.format("%s/%s", path, sdf.format(new Date()));
        }
        if (null != pathTypeEnabled && pathTypeEnabled.booleanValue() && StringUtils.isNotBlank((CharSequence)fileName) && StringUtils.isNotBlank((CharSequence)(fileType = FilenameUtils.getExtension((String)fileName)))) {
            path = String.format("%s/%s", path, fileType);
        }
        return path;
    }
}

