/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.basic.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;

public class NetworkUtil {
    private static final String LOCAL_IP = "127.0.0.1";

    public static List<String> getLocalIpList() {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress == null || !(inetAddress instanceof Inet4Address)) continue;
                    String ip = inetAddress.getHostAddress();
                    ipList.add(ip);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return ipList;
    }

    public static String getEnhanceIp(String ipStartWith) {
        Optional<String> optional = NetworkUtil.getLocalIpList().stream().filter(c -> c.startsWith(ipStartWith)).findFirst();
        if (optional.isEmpty()) {
            return "";
        }
        return optional.get();
    }

    public static InetAddress getLocalHostLanAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + String.valueOf(e));
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public static String getIpAddr(HttpServletRequest request) {
        if (request == null) {
            return "unknown";
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? LOCAL_IP : ip;
    }

    public static boolean internalIp(String ip) {
        boolean res = false;
        if (ip == null) {
            return true;
        }
        byte[] addr = NetworkUtil.textToNumericFormatV4(ip);
        if (addr != null) {
            res = NetworkUtil.internalIp(addr) || LOCAL_IP.equals(ip);
        }
        return res;
    }

    private static boolean internalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        boolean flag = false;
        switch (b0) {
            case 10: {
                flag = true;
                break;
            }
            case -84: {
                if (b1 < 16 || b1 > 31) break;
                flag = true;
                break;
            }
            case -64: {
                if (b1 != -88) break;
                flag = true;
                break;
            }
        }
        return flag;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] textToNumericFormatV4(String text) {
        if (text.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[4];
        String[] elements = text.split("\\.", -1);
        try {
            switch (elements.length) {
                case 1: {
                    long l = Long.parseLong(elements[0]);
                    if (l < 0L) return null;
                    if (l > 0xFFFFFFFFL) {
                        return null;
                    }
                    bytes[0] = (byte)(l >> 24 & 0xFFL);
                    bytes[1] = (byte)((l & 0xFFFFFFL) >> 16 & 0xFFL);
                    bytes[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    return bytes;
                }
                case 2: {
                    long l = Integer.parseInt(elements[0]);
                    if (l < 0L) return null;
                    if (l > 255L) {
                        return null;
                    }
                    bytes[0] = (byte)(l & 0xFFL);
                    l = Integer.parseInt(elements[1]);
                    if (l < 0L) return null;
                    if (l > 0xFFFFFFL) {
                        return null;
                    }
                    bytes[1] = (byte)(l >> 16 & 0xFFL);
                    bytes[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    return bytes;
                }
                case 3: {
                    long l;
                    int i = 0;
                    while (true) {
                        if (i >= 2) {
                            l = Integer.parseInt(elements[2]);
                            if (l < 0L) return null;
                            if (l <= 65535L) break;
                            return null;
                        }
                        l = Integer.parseInt(elements[i]);
                        if (l < 0L) return null;
                        if (l > 255L) {
                            return null;
                        }
                        bytes[i] = (byte)(l & 0xFFL);
                        ++i;
                    }
                    bytes[2] = (byte)(l >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    return bytes;
                }
                case 4: {
                    int i = 0;
                    while (i < 4) {
                        long l = Integer.parseInt(elements[i]);
                        if (l < 0L) return null;
                        if (l > 255L) {
                            return null;
                        }
                        bytes[i] = (byte)(l & 0xFFL);
                        ++i;
                    }
                    return bytes;
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getLocalIp() {
        String ip = "";
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                ip = addr.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return ip;
        }
        try {
            Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
            while (e1.hasMoreElements()) {
                NetworkInterface ni = e1.nextElement();
                if (!ni.getName().equals("eth0")) continue;
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ia = e2.nextElement();
                    if (ia instanceof Inet6Address) continue;
                    ip = ia.getHostAddress();
                    return ip;
                }
                break;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "";
    }
}

