/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.basic.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static String format(Date date, String pattern) {
        if (date == null || StringUtils.isBlank((CharSequence)pattern)) {
            return "";
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static Date setTimeStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date setTimeClose(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static double getDifferenceInDays(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return -1.0;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(d1);
        cal1.set(11, 0);
        cal1.set(12, 0);
        cal1.set(13, 0);
        cal1.set(14, 0);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(d2);
        cal2.set(11, 0);
        cal2.set(12, 0);
        cal2.set(13, 0);
        cal2.set(14, 0);
        if (cal1.getTimeInMillis() == cal2.getTimeInMillis()) {
            return 0.0;
        }
        long diffInMillis = Math.abs(cal1.getTimeInMillis() - cal2.getTimeInMillis());
        return Math.ceil((double)diffInMillis / 8.64E7);
    }

    public static double getDifferenceInMinutes(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return -1.0;
        }
        Date min = null;
        Date max = null;
        if (d1.getTime() > d2.getTime()) {
            max = d1;
            min = d2;
        } else {
            max = d2;
            min = d1;
        }
        long diffInMilliSeconds = max.getTime() - min.getTime();
        long diffInMinutes = diffInMilliSeconds / 60000L;
        long diffInSeconds = diffInMilliSeconds % 60000L / 1000L;
        double result = (double)diffInMinutes + (double)diffInSeconds / 60.0;
        return result;
    }

    public static Date getWeekEndDate(int week) {
        if (week <= 0) {
            throw new IllegalArgumentException("\u5468\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        calendar.set(7, 2);
        calendar.add(3, week - 1);
        calendar.add(7, 6);
        return calendar.getTime();
    }

    public static Date getTodayStart() {
        return DateUtil.setTimeStart(new Date());
    }

    public static Date getTodayEnd() {
        return DateUtil.setTimeClose(new Date());
    }

    public static Date getYesterdayStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return DateUtil.setTimeStart(calendar.getTime());
    }

    public static Date getYesterdayEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return DateUtil.setTimeClose(calendar.getTime());
    }

    public static Date getWeekStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        return DateUtil.setTimeStart(calendar.getTime());
    }

    public static Date getWeekEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        calendar.add(7, 6);
        return DateUtil.setTimeClose(calendar.getTime());
    }

    public static Date getLastWeekStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(3, -1);
        calendar.set(7, 2);
        return DateUtil.setTimeStart(calendar.getTime());
    }

    public static Date getLastWeekEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(3, -1);
        calendar.set(7, 2);
        calendar.add(7, 6);
        return DateUtil.setTimeClose(calendar.getTime());
    }

    public static Date getMonthStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        return DateUtil.setTimeStart(calendar.getTime());
    }

    public static Date getMonthEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMaximum(5));
        return DateUtil.setTimeClose(calendar.getTime());
    }

    public static Date getLastMonthStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        return DateUtil.setTimeStart(calendar.getTime());
    }

    public static Date getLastMonthEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        return DateUtil.setTimeClose(calendar.getTime());
    }
}

