/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.basic.toolkit.security.support;

import cn.jslim.basic.toolkit.security.SecureAes;
import cn.jslim.basic.toolkit.security.SecureOperation;
import cn.jslim.basic.toolkit.security.SecureOperationKeyManager;
import cn.jslim.basic.toolkit.security.SecureRsa;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;

public class StandardSecureOperation
implements SecureOperation {
    private final SecureOperationKeyManager keyManager;

    public StandardSecureOperation(SecureOperationKeyManager keyManager) {
        if (keyManager == null) {
            throw new NullPointerException("keyManager");
        }
        this.keyManager = keyManager;
    }

    @Override
    public String encode(String terminal, String response) throws Exception {
        String aesKey = SecureAes.createKey();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String signString = String.format("timestamp=%s&terminal=%s", timestamp, terminal);
        String platformPrivateKey = this.keyManager.getPrivateKey(terminal);
        String terminalPublickKey = this.keyManager.getPublicKey(terminal);
        String signResult = SecureRsa.sign(signString, platformPrivateKey);
        String dataResult = SecureAes.encrypt(response, aesKey);
        String passResult = SecureRsa.encryptByPublicKey(aesKey, terminalPublickKey);
        JSONObject result = new JSONObject();
        result.put((Object)"sign", (Object)signResult);
        result.put((Object)"data", (Object)dataResult);
        result.put((Object)"pass", (Object)passResult);
        result.put((Object)"time", (Object)timestamp);
        return result.toJSONString(new JSONWriter.Feature[0]);
    }

    @Override
    public String decode(String terminal, String request) throws Exception {
        JSONObject object = JSON.parseObject((String)request);
        String signString = object.getString("sign");
        String dataString = object.getString("data");
        String passString = object.getString("pass");
        String timeString = object.getString("time");
        String signValue = String.format("timestamp=%s&terminal=%s", timeString, terminal);
        String passValue = SecureRsa.decryptByPrivateKey(passString, this.keyManager.getPrivateKey(terminal));
        if (!SecureRsa.verify(signValue, this.keyManager.getPublicKey(terminal), signString)) {
            throw new Exception("\u7b7e\u5b57\u5f02\u5e38");
        }
        return SecureAes.decrypt(dataString, passValue);
    }
}

