/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.basic.toolkit.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

public class SecurePwd {
    private static final String HEX_NUMS_STR = "0123456789ABCDEF";
    private static final Integer SALT_LENGTH = 12;

    public static byte[] hexStringToByte(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] hexChars = hex.toCharArray();
        int i = 0;
        while (i < len) {
            int pos = i * 2;
            result[i] = (byte)(HEX_NUMS_STR.indexOf(hexChars[pos]) << 4 | HEX_NUMS_STR.indexOf(hexChars[pos + 1]));
            ++i;
        }
        return result;
    }

    public static String byteToHexString(byte[] b) {
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            Object hex = Integer.toHexString(b[i] & 0xFF);
            if (((String)hex).length() == 1) {
                hex = "0" + (String)hex;
            }
            hexString.append(((String)hex).toUpperCase());
            ++i;
        }
        return hexString.toString();
    }

    public static boolean validPasswordWithoutException(String password, String passwordInDb) {
        try {
            return SecurePwd.validPassword(password, passwordInDb);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validPassword(String password, String passwordInDb) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] pwdInDb = SecurePwd.hexStringToByte(passwordInDb);
        byte[] salt = new byte[SALT_LENGTH.intValue()];
        System.arraycopy(pwdInDb, 0, salt, 0, SALT_LENGTH);
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(salt);
        md.update(password.getBytes("UTF-8"));
        byte[] digest = md.digest();
        byte[] digestInDb = new byte[pwdInDb.length - SALT_LENGTH];
        System.arraycopy(pwdInDb, SALT_LENGTH, digestInDb, 0, digestInDb.length);
        return Arrays.equals(digest, digestInDb);
    }

    public static String getEncryptedPwd(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] pwd = null;
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[SALT_LENGTH.intValue()];
        random.nextBytes(salt);
        MessageDigest md = null;
        md = MessageDigest.getInstance("MD5");
        md.update(salt);
        md.update(password.getBytes("UTF-8"));
        byte[] digest = md.digest();
        pwd = new byte[digest.length + SALT_LENGTH];
        System.arraycopy(salt, 0, pwd, 0, SALT_LENGTH);
        System.arraycopy(digest, 0, pwd, SALT_LENGTH, digest.length);
        return SecurePwd.byteToHexString(pwd);
    }

    public static String getEncryptedPwdWithoutException(String password) {
        try {
            return SecurePwd.getEncryptedPwd(password);
        }
        catch (Exception e) {
            return password;
        }
    }
}

