/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.basic.toolkit.security;

import cn.jslim.basic.toolkit.security.SecureAes;
import org.apache.commons.lang3.StringUtils;

public class SecureAesToolkit {
    private final String key;

    public SecureAesToolkit(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("key");
        }
        this.key = key;
    }

    public String encrypt(String value) throws Exception {
        if (value == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        return SecureAes.encrypt(value, this.key);
    }

    public String encryptWithoutException(String value) {
        try {
            return this.encrypt(value);
        }
        catch (Exception e) {
            return value;
        }
    }

    public String decrypt(String value) throws Exception {
        if (value == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        return SecureAes.decrypt(value, this.key);
    }

    public String decryptWithoutException(String value) {
        try {
            return this.decrypt(value);
        }
        catch (Exception e) {
            return value;
        }
    }
}

