/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.basic.toolkit.security;

import cn.jslim.basic.toolkit.security.Base64;
import java.security.Key;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecureAes {
    private static final String NAME = "AES";
    private static final String CHARSET = "UTF-8";
    private static final String PADDING = "AES/CBC/PKCS5Padding";

    private static void valid(String val, String key) throws Exception {
        if (val == null || val.trim().length() == 0) {
            throw new Exception("val must not be blank");
        }
        if (key == null || key.trim().length() == 0) {
            throw new Exception("key must not be blank");
        }
        if (key.trim().length() != 32) {
            throw new Exception("key format error");
        }
    }

    public static String createKey() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String encrypt(String val, String key) throws Exception {
        SecureAes.valid(val, key);
        String vector = key.substring(16);
        String rawKey = key.substring(0, 16);
        Cipher cipher = Cipher.getInstance(PADDING);
        byte[] raw = rawKey.getBytes();
        SecretKeySpec keySpec = new SecretKeySpec(raw, NAME);
        IvParameterSpec iv = new IvParameterSpec(vector.getBytes());
        cipher.init(1, (Key)keySpec, iv);
        byte[] encrypted = cipher.doFinal(val.getBytes(CHARSET));
        return Base64.encode(encrypted);
    }

    public static String decrypt(String val, String key) throws Exception {
        SecureAes.valid(val, key);
        String vector = key.substring(16);
        String rawKey = key.substring(0, 16);
        Cipher cipher = Cipher.getInstance(PADDING);
        byte[] raw = rawKey.getBytes();
        SecretKeySpec keySpec = new SecretKeySpec(raw, NAME);
        IvParameterSpec iv = new IvParameterSpec(vector.getBytes());
        cipher.init(2, (Key)keySpec, iv);
        byte[] encrypted = Base64.decode(val);
        byte[] original = cipher.doFinal(encrypted);
        return new String(original, CHARSET);
    }

    public static void main(String[] args) throws Exception {
        String key = "0a566f191171417ca2520365bf4ccd7e";
        String val = "123456";
        System.err.println(SecureAes.createKey());
        System.err.println(SecureAes.encrypt(val, key));
        System.err.println(SecureAes.encrypt(val, key));
    }
}

