/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.basic.toolkit.domain;

import cn.jslim.basic.toolkit.domain.LogicException;
import cn.jslim.basic.toolkit.domain.ResultStatus;
import com.alibaba.fastjson2.JSON;
import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String message;
    private String code;
    private T data;

    public Result<T> setData(T data) {
        this.data = data;
        return this;
    }

    public Result<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public Result<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return ResultStatus.SUCCESS.getValue().equals(this.code);
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public void catchException() {
        if (this.isFailure()) {
            throw LogicException.of(ResultStatus.SERVICE_FAILED, this.message);
        }
    }

    public String toJsonString() {
        return JSON.toJSONString((Object)this);
    }

    public static <E> Result<E> success(E data, String message) {
        Result<E> result = new Result<E>();
        result.setCode(ResultStatus.SUCCESS.getValue());
        result.setData(data);
        result.setMessage(StringUtils.isBlank((CharSequence)message) ? ResultStatus.SUCCESS.getLabel() : message);
        return result;
    }

    public static <E> Result<E> success(E data) {
        return Result.success(data, null);
    }

    public static <E> Result<E> success(String message) {
        return Result.success(null, message);
    }

    public static <E> Result<E> success() {
        return Result.success(null, null);
    }

    public static <E> Result<E> failure(String code, String message, E data) {
        Result<E> result = new Result<E>();
        result.setCode(StringUtils.isBlank((CharSequence)code) ? ResultStatus.FAILURE.getValue() : code);
        result.setData(data);
        result.setMessage(StringUtils.isBlank((CharSequence)message) ? ResultStatus.FAILURE.getLabel() : message);
        return result;
    }

    public static <E> Result<E> failure(String code, String message) {
        return Result.failure(code, message, null);
    }

    public static <E> Result<E> failure(ResultStatus resultStatus) {
        if (resultStatus == null) {
            resultStatus = ResultStatus.FAILURE;
        }
        return Result.failure(resultStatus.getValue(), resultStatus.getLabel(), null);
    }

    public static <E> Result<E> failure(ResultStatus resultStatus, String message) {
        if (resultStatus == null) {
            resultStatus = ResultStatus.FAILURE;
        }
        return Result.failure(resultStatus.getValue(), StringUtils.isBlank((CharSequence)message) ? resultStatus.getLabel() : message, null);
    }

    public static <E> Result<E> failure(LogicException e) {
        return Result.failure(e.getResultStatus());
    }

    public static <E> Result<E> callback(Supplier<E> supplier) {
        try {
            E data = supplier.get();
            return Result.success(data);
        }
        catch (LogicException e) {
            return Result.failure(e);
        }
        catch (Throwable cause) {
            return Result.failure(ResultStatus.FAILURE, cause.getMessage());
        }
    }
}

