/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.basic.toolkit.domain;

import java.io.Serializable;
import java.util.function.Supplier;

public class R<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEF_SUCCESS = "success";
    private static final String DEF_FAILURE = "failure";
    private boolean success = false;
    private String message = "";
    private T result;

    public boolean isSuccess() {
        return this.success;
    }

    public R<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public R<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public T getResult() {
        return this.result;
    }

    public R<T> setResult(T result) {
        this.result = result;
        return this;
    }

    public boolean isFailure() {
        return !this.success;
    }

    public static <T> R<T> success(T data, String message) {
        R<T> r = new R<T>();
        r.setSuccess(true);
        r.setMessage(message);
        r.setResult(data);
        return r;
    }

    public static <T> R<T> success(T data) {
        return R.success(data, DEF_SUCCESS);
    }

    public static <T> R<T> success(String message) {
        return R.success(null, message);
    }

    public static <T> R<T> success() {
        return R.success(null, DEF_SUCCESS);
    }

    public static <T> R<T> failure(T data, String message) {
        R<T> r = new R<T>();
        r.setSuccess(false);
        r.setMessage(message);
        r.setResult(data);
        return r;
    }

    public static <T> R<T> failure(T data) {
        return R.failure(data, DEF_FAILURE);
    }

    public static <T> R<T> failure(String message) {
        return R.failure(null, message);
    }

    public static <T> R<T> failure() {
        return R.failure(null, DEF_FAILURE);
    }

    public static <T> R<T> callback(Supplier<T> supplier) {
        if (supplier == null) {
            return R.failure();
        }
        try {
            T data = supplier.get();
            return R.success(data);
        }
        catch (Throwable cause) {
            return R.failure(cause.getMessage());
        }
    }
}

