/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.basic.toolkit.domain;

import cn.jslim.basic.toolkit.domain.PageDomain;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> data;
    private long total = 0L;
    private long start = 0L;
    private long limit = 10L;

    public List<T> getData() {
        return this.data;
    }

    public Page<T> setData(List<T> data) {
        this.data = data;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public Page<T> setTotal(long total) {
        this.total = total;
        return this;
    }

    public long getStart() {
        return this.start;
    }

    public Page<T> setStart(long start) {
        this.start = start;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public Page<T> setLimit(long limit) {
        this.limit = limit;
        return this;
    }

    public long getTotalPage() {
        if (this.limit < 0L || this.total < 0L) {
            return 0L;
        }
        return this.total % this.limit == 0L ? this.total / this.limit : this.total / this.limit + 1L;
    }

    public boolean getHasNext() {
        return this.getTotalPage() == 0L && this.limit < this.total;
    }

    public boolean getHasPrev() {
        return this.start >= this.limit;
    }

    public static <T> Page<T> of() {
        return new Page<T>();
    }

    public static <T> Page<T> of(Page<?> data) {
        if (data == null) {
            return Page.of();
        }
        Page<T> page = new Page<T>();
        page.setStart(data.getStart());
        page.setLimit(data.getLimit());
        return page;
    }

    public static <T> Page<T> of(int start, int limit) {
        return new Page<T>().setStart(start).setLimit(limit);
    }

    public static <T> Page<T> of(long start, long limit) {
        return new Page<T>().setStart(start).setLimit(limit);
    }

    public static <T> Page<T> ofStart(int start) {
        return new Page<T>().setStart(start);
    }

    public static <T> Page<T> ofStart(long start) {
        return new Page<T>().setStart(start);
    }

    public static <T> Page<T> ofLimit(int limit) {
        return new Page<T>().setLimit(limit);
    }

    public static <T> Page<T> ofLimit(long limit) {
        return new Page<T>().setLimit(limit);
    }

    public static <T> Page<T> of(HttpServletRequest request) {
        String start = request.getParameter("start");
        String limit = request.getParameter("limit");
        Long startL = 0L;
        Long limitL = 10L;
        if (StringUtils.isNumeric((CharSequence)start)) {
            startL = Long.parseLong(start);
        }
        if (StringUtils.isNumeric((CharSequence)limit)) {
            limitL = Long.parseLong(limit);
        }
        return Page.of(startL, limitL);
    }

    public static <T> Page<T> of(PageDomain domain) {
        if (domain == null) {
            return Page.of();
        }
        return Page.of(domain.getStart(), domain.getLimit());
    }
}

